/* Sample REXX program for use with Debugo */
/* Get memory page count report. Works on 2.1 debug kernel */

parse arg .


if "DEBUGO" <> translate(address()) then do
  say 'Expected Debugo environment.'
  exit 0
end

say ""

/* push to send command to debug kernel */
push "dd _pgphyspages l1"

/* get all the lines the debug kernel has to send */
/* use debugo special function sz = getline() to get them */
i = 0
do while queued() > 0
  i = i + 1
  select
    when i=2 then szPhys = word( getline(), 2 )
    otherwise junk = getline()
  end
end

push "dd _pgresidentpages l1"
i = 0
do while queued() > 0
  i = i + 1
  select
    when i=2 then szRes = word( getline(), 2 )
    otherwise junk = getline()
  end
end

push "dd _pgswappablepages l1"
i = 0
do while queued() > 0
  i = i + 1
  select
    when i=2 then szSwap = word( getline(), 2 )
    otherwise junk = getline()
  end
end

push "dd _pgdiscardablepages l1"
i = 0
do while queued() > 0
  i = i + 1
  select
    when i=2 then szDis = word( getline(), 2 )
    otherwise junk = getline()
  end
end

sum = 0

say 'Physical      ' szPhys
say 'Resident      ' szRes
say 'Swappable     ' szSwap
say 'Discardable   ' szDis
say 'Sum of resident, swappable, discardable:' d2x( x2d(szDis) + x2d( szRes ) + x2d( szSwap ) )
return 0
